#include "Triangle.h"
#include <math.h>

Triangle::Triangle(float * v1, float * v2, float * v3){
	//calcSideLengths(v1, v2, v3);
	//calcAngles();
	//calcIncenter();
	calcBarycenter(v1, v2, v3);
	calcNormal(v1, v2, v3);
	calcRadius(v1, v2, v3);
}

void Triangle::calcSideLengths(float * v1, float * v2, float * v3) {
	a = distance(v1, v2);
	b = distance(v2, v3);
	c = distance(v3, v1);
}

void Triangle::calcAngles(){
	/*
	float mx = (float)max(max(a, b), max(b, c));
	
	if(a == mx){
		B = asin(b/a);
		C = asin(c/a);
		A = 180.0f - B - C;
	} else if(b == mx) {
		A = asin(a/b);
		C = asin(c/b);
		B = 180.0f - A - C;
	} else {
		A = asin(a/c);
		B = asin(b/c);
		C = 180.0f - A - B;
	}*/
}

void Triangle::calcIncenter(){
	//float perimeter = a + b + c;
	//incenter[0] = ( (a * Ax) + (b * Bx) + (c * Cx) ) / perimeter;
	//incenter[1] = ( (a * Ay) + (b * By) + (c * Cy) ) / perimeter;
	//incenter[2] = ( (a * Az) + (b * Bz) + (c * Cz) ) / perimeter;
}

void Triangle::calcBarycenter(float * v1, float * v2, float * v3){
	for(int i = 0; i < 3; i++){
		pos[i] = barycenter[i] = (v1[i] + v2[i] + v3[i]) / 3.0f;
	}
}

void Triangle::calcRadius(float * v1, float * v2, float * v3){
	a = distance(v1, v2);
	b = distance(v2, v3);
	area = (a + b)/ M_PI / 2.0f; //AREA DIVIDED BY PI!!
	radius = (float)sqrt(area); // note the extreme approxiamation
}


void Triangle::calcNormal(float * f1, float * f2, float * f3){
	float a[3], b[3], result[3];
	float length;

	a[0] = f1[0] - f2[0];
	a[1] = f1[1] - f2[1];
	a[2] = f1[2] - f2[2];

	b[0] = f1[0] - f3[0];
	b[1] = f1[1] - f3[1];
	b[2] = f1[2] - f3[2];

	result[0] = a[1] * b[2] - b[1] * a[2];
	result[1] = b[0] * a[2] - a[0] * b[2];
	result[2] = a[0] * b[1] - b[0] * a[1];

	// Calculate the length of the normal
	length = (float)sqrt((result[0] * result[0]) + (result[1] * result[1]) + (result[2] * result[2]));
	
	for(int i = 0; i < 3; i++){
		// Normalize and specify the normal
		normal[i] = result[i]/length;
	}
}

float distance(const float * p0, const float * p1){
	float dx = p0[0] - p1[0];
	float dy = p0[1] - p1[1];
	float dz = p0[2] - p1[2];
	return (float)sqrt(dx * dx + dy * dy + dz * dz);
}

float radToDeg(float rad){
	return (float)(rad*180.0f/M_PI);
}

float max(float a, float b){
	return (a > b)? a : b;
}

float saturate(float a){
	a = (a > 1)? 1 : a;
	return (a < 0) ? 0 : a;
}

/*returns the cross product of the two vectors
*/
/*
MyVector cross(MyVector _v){
	MyVector c;
	c.set3d(y*_v.z - z*_v.y, z*_v.x - x*_v.z, x*_v.y - y*_v.x);
	return c;
}
*/

/*returns the dot product of the two vectors
*/
float dot(const float * v1, const float * v2){
	return v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2];
}

/*returns the dot product of the two vectors
*/
void normalize(float * v){
	float length = sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
	for(int i = 0; i < 3; i++){
		v[i] = v[i] / length;
	}
}

void setval(float * dest, const float * src){
	for(int i = 0; i < 3; i++){
		dest[i] = src[i];
	}
}